/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.switchsupport;

import io.gitlab.jfronny.commons.switchsupport.Result;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public sealed interface Opt<T> {
    public static <T> Opt<T> empty() {
        return None.of();
    }

    public static <T> Opt<T> of(T value) {
        return value == null ? None.of() : Some.of(value);
    }

    public static <T> Opt<T> over(Optional<T> optional) {
        return optional.map(Opt::of).orElseGet(Opt::empty);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public T get() {
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Some some = (Some)opt2;
                try {
                    Object t;
                    Object value = t = some.value();
                    return value;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        None none = (None)opt2;
        throw new IllegalStateException("Opt is None");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public T getOrElse(T defaultValue) {
        T t;
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Some some = (Some)opt2;
                try {
                    Object t2;
                    Object value = t2 = some.value();
                    t = value;
                    return t;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        None none = (None)opt2;
        t = defaultValue;
        return t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public T getOrElseGet(Supplier<T> supplier) {
        T t;
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Some some = (Some)opt2;
                try {
                    Object t2;
                    Object value = t2 = some.value();
                    t = value;
                    return t;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        None none = (None)opt2;
        t = supplier.get();
        return t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <X extends Throwable> T getOrElseThrow(Supplier<X> exceptionSupplier) throws X {
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Some some = (Some)opt2;
                try {
                    Object t;
                    Object value = t = some.value();
                    return value;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        None none = (None)opt2;
        throw (Throwable)exceptionSupplier.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R> Opt<R> map(Function<T, R> mapper) {
        Record record;
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value;
                Some some = (Some)opt2;
                try {
                    Object t;
                    value = t = some.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                record = Some.of(mapper.apply(value));
                return record;
            }
            case 1: 
        }
        None none = (None)opt2;
        record = None.of();
        return record;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R> Opt<R> flatMap(Function<T, Opt<R>> mapper) {
        Opt<Object> opt;
        Opt opt2 = this;
        Objects.requireNonNull(opt2);
        Opt opt22 = opt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt22, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Some some = (Some)opt22;
                try {
                    Object t;
                    Object value = t = some.value();
                    opt = mapper.apply(value);
                    return opt;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        None none = (None)opt22;
        opt = None.of();
        return opt;
    }

    default public void ifPresent(Consumer<T> consumer) {
        Opt opt = this;
        if (opt instanceof Some) {
            Some some = (Some)opt;
            try {
                Object t;
                Object value = t = some.value();
                consumer.accept(value);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public void ifPresentOrElse(Consumer<T> consumer, Runnable runnable) {
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Some some = (Some)opt2;
                try {
                    Object t;
                    Object value = t = some.value();
                    consumer.accept(value);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        None none = (None)opt2;
        runnable.run();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Opt<T> filter(Predicate<T> predicate) {
        Opt opt;
        Opt opt2 = this;
        Objects.requireNonNull(opt2);
        Opt opt3 = opt2;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, Some.class, None.class}, (Object)opt3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Some some = (Some)opt3;
                    try {
                        Object t;
                        Object value = t = some.value();
                        if (predicate.test(value)) {
                            opt = this;
                            return opt;
                        }
                        n = 1;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                continue block7;
                case 1: {
                    Some some = (Some)opt3;
                    opt = None.of();
                    return opt;
                }
                case 2: 
            }
            break;
        }
        None none = (None)opt3;
        opt = this;
        return opt;
    }

    default public Opt<T> or(Supplier<Opt<T>> supplier) {
        Opt<T> opt = this;
        Objects.requireNonNull(opt);
        Opt<T> opt2 = opt;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Some some = (Some)opt2;
                yield this;
            }
            case 1 -> {
                None none = (None)opt2;
                yield supplier.get();
            }
        };
    }

    default public Opt<T> orElse(Opt<T> other) {
        Opt<T> opt = this;
        Objects.requireNonNull(opt);
        Opt<T> opt2 = opt;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Some some = (Some)opt2;
                yield this;
            }
            case 1 -> {
                None none = (None)opt2;
                yield other;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public T orElseGet(Supplier<T> supplier) {
        T t;
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Some some = (Some)opt2;
                try {
                    Object t2;
                    Object value = t2 = some.value();
                    t = value;
                    return t;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        None none = (None)opt2;
        t = supplier.get();
        return t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <X> Result<T, X> toResult(Supplier<X> errorSupplier) {
        Result result;
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value;
                Some some = (Some)opt2;
                try {
                    Object t;
                    value = t = some.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                result = Result.success(value);
                return result;
            }
            case 1: 
        }
        None none = (None)opt2;
        result = Result.failure(errorSupplier.get());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Stream<T> stream() {
        Stream stream;
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value;
                Some some = (Some)opt2;
                try {
                    Object t;
                    value = t = some.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                stream = Stream.of(value);
                return stream;
            }
            case 1: 
        }
        None none = (None)opt2;
        stream = Stream.empty();
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Optional<T> toOptional() {
        Optional optional;
        Opt opt = this;
        Objects.requireNonNull(opt);
        Opt opt2 = opt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, (Object)opt2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value;
                Some some = (Some)opt2;
                try {
                    Object t;
                    value = t = some.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                optional = Optional.of(value);
                return optional;
            }
            case 1: 
        }
        None none = (None)opt2;
        optional = Optional.empty();
        return optional;
    }

    public record None<T>() implements Opt<T>
    {
        public static <T> None<T> of() {
            return new None<T>();
        }
    }

    public record Some<T>(T value) implements Opt<T>
    {
        public static <T> Some<T> of(T value) {
            return new Some<T>(value);
        }
    }
}

